#include <stdlib.h>
#include "dmlib.h"

error_code
dm_create( char *mname, int size, void **head, mh_com **addr )
{
  unsigned short attrev = 0xC000, /* Sharable, Sticky Bit */
    typlang = 0x400; /* Type "data module" */
  unsigned long perm = 0x333; /* RW pour tout le monde */
  error_code ok ;

  ok = _os_datmod(
		  mname,
		  size,
		  &attrev,
		  &typlang,
		  perm,
		  head,
		  addr) ;
    /* the data module has just been created */

    return ok ;
}

error_code
dm_link(  char *mname, void **head, mh_com **addr )
{
  unsigned short attrev = 0xC000, /* Sharable, Sticky Bit */
    typlang = 0x400; /* Type "data module" */
  unsigned long perm = 0x333; /* RW pour tout le monde */
  error_code ok ;

  ok = _os_link(&mname,
		addr,
		head,
		&typlang,
		&attrev ) ;
  /* the data-module already exists */
  return ok ;
}

error_code
dm_init( char *mname, int size, void **head, mh_com **addr )
{
  unsigned short attrev = 0xC000, /* Sharable, Sticky Bit */
    typlang = 0x400; /* Type "data module" */
  unsigned long perm = 0x333; /* RW pour tout le monde */
  error_code ok ;

  if( !(ok = _os_link(&mname,
		    addr,
		    head,
		    &typlang,
		    &attrev)) ) {
    /* the data-module already exists */
    return ok ;
  }
  else if ( !(ok = _os_datmod(
		       mname,
		       size,
		       &attrev,
		       &typlang,
		       perm,
		       head,
		       addr))) {
    /* the data module has just been created */

    return ok ;
  }
  else return ok ;
}

error_code
dm_finish( mh_com **addr )
{
  if ( *addr ) _os_unlink ( *addr ) ;
  *addr = NULL ;
  return 0 ;
}
