
#include "versions.h"

#define EVB_SYNCH 0xDADAFADA
#define EVB_ACTIVE 0xDADAD0D0
#define MINIMUM_BUF_SIZE 0x10

typedef struct evb_buf evb_buf_header ;
struct evb_buf {
  evb_buf_header *prev, *next ; /* pointeur sur previous/next block */
  int buf_ok ;
  int bsize ; /* taille du bloc */
  int size ; /* taille du message */
#if EVB_VERSION>4
  int locked ; /* Locked by hand. Do not delete automatically */
  unsigned char tag[16] ;
#endif
} ;

typedef struct {
  int synch,  /* Synchronisation word */
    active,   /* Creator is still active */
    version,  /* Numero de version */
    size,     /* Size available for messages */
    nbbuf;   /* number of available messages */
  int gattempt, /* Nb of garbage collection */
    gsuccess ;  /* Nb of successful .... */
  process_id owner ;    /* PID of owner process */
  semaphore exclusion ; /* Mutual exclusion for access to the mailbox */
  evb_buf_header
    *free_head, *free_tail,
    *buf_head, *buf_tail ;
  mh_com *addr ;/* Address of the data module */
  int
    reserved[8]; /* Reserved for future use */
  void *memory_arena ;
} evbuffer ;
