/******************************************************************

  Gestion des Fastbuffers.

  Longueur fixe.
  Producteur : ItFast
  Consomateur : Trigger2

  1 data module.
  MAX_FAST_BUFFER buffers de longueur fixe.
  Gestion circulaire avec 2 indices : OldBuffer et NextBuffer.
  Deux compteurs : FreeBuffers et UsedBuffers.

  Producteur: 
  FB_get()
     Si ( FreeBuffers > 0 ) {
       FreeBuffers -- ;
       CurBuffer = NextBuffer ++ ;
       if ( NextBuffer >= MaxBuffers ) NextBuffer = 0 ;
       return addresse(CurBuffer) ;
     }
     sinon return NULL ;

  Consomateur:
  FB_use()
     Si ( UsedBuffers > 0 ) {
       return adresse( OldBuffer ) ;
     }
     sinon return NULL ;

  FB_free()
     OldBuffer++ ;
     Si ( OldBuffer >= MaxBuffer ) OldBuffer = 0 ;
     UsedBuffers-- ;
  }

  ATTENTION:
  Il n'y a pas de mecanisme d'exclusion !!!!! La fonction FB_get() est
  utilisee dans une routine d'IT, donc ininterruptible.
  Les fonctions FB_use et FB_free dans un process user, donc interruptible.

************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <const.h>

#define _FAST_BUFFER_LIB_
#include "fastlib.h"
#include "augererr.h"

void
FB_status( FILE *fout )
{
  fprintf( fout, "Status of Fast Buffers\n" ) ;
#if FAST_VERSION>1
  fprintf( fout, "  Total Buffers : %d\n", FastBuffer->TotalBuffers ) ;
#endif
  fprintf( fout, "  Free Buffers  : %d\n", FastBuffer->FreeBuffers ) ;
  fprintf( fout, "  Used Buffers  : %d\n", FastBuffer->UsedBuffers ) ;
  fprintf( fout, "  Old Buffer    : %d\n", FastBuffer->OldBuffer ) ;
  fprintf( fout, "  Next Buffer   : %d\n", FastBuffer->NextBuffer ) ;
}

void
FB_finish()
{
  dm_finish( &FastModule ) ;
}

error_code
FB_reset()
{
#if FAST_VERSION>1
  FastBuffer->FreeBuffers = FastBuffer->TotalBuffers ;
#else
  FastBuffer->FreeBuffers = MAX_FAST_BUFFER ;
#endif
  FastBuffer->UsedBuffers = 0 ;
  FastBuffer->OldBuffer = 0 ;
  FastBuffer->NextBuffer = 0 ;
  FastBuffer->MaxUsed = 0 ;
  return FBError = SUCCESS ;
}

error_code
#if FAST_VERSION>1
FB_init( int nbuffers )
#else
FB_init()
#endif
{
  /* Link sur data module */
#if FAST_VERSION>1
  if ( dm_init( FAST_MODULE,
		sizeof( FAST_BUFFER ) + nbuffers*sizeof(FAST_EVENT),
		(void **)&FastBuffer,
		&FastModule ) != 0 ) return FAST_CANT_OPEN ;
  /* initialisation des pointeurs et indices */
  if ( FastBuffer->TotalBuffers == 0 ) {
    FastBuffer->TotalBuffers = nbuffers ;
    FB_reset() ;
  }
#else
  if ( dm_init( FAST_MODULE, sizeof( FAST_BUFFER ), (void **)&FastBuffer,
		&FastModule ) != 0 ) return FAST_CANT_OPEN ;
  /* initialisation des pointeurs et indices */
  if ( FastBuffer->FreeBuffers == 0 ) FB_reset() ;
#endif
  return FBError = SUCCESS ;
}

error_code
FB_get( FAST_EVENT **buff )
{
  int curbuff ;

  if ( FastBuffer->FreeBuffers == 0 ) return FBError = FAST_NO_BUFFER ;

  curbuff = FastBuffer->NextBuffer++ ;
#if FAST_VERSION>1
  if ( FastBuffer->NextBuffer >= FastBuffer->TotalBuffers )
#else
  if ( FastBuffer->NextBuffer >= MAX_FAST_BUFFER )
#endif
    FastBuffer->NextBuffer = 0 ;
  FastBuffer->FreeBuffers-- ;
  FastBuffer->UsedBuffers++ ;
  if ( FastBuffer->MaxUsed < FastBuffer->UsedBuffers )
    FastBuffer->MaxUsed = FastBuffer->UsedBuffers ;
  *buff = &FastBuffer->buffers[curbuff] ;
  return FBError = SUCCESS ;
}

error_code
FB_use( FAST_EVENT **buf )
{
  if ( FastBuffer->UsedBuffers ) {
    *buf = &FastBuffer->buffers[FastBuffer->OldBuffer] ;
    return FBError = SUCCESS ;
  }
  else return FBError = FAST_NO_BUFFER ;
}

error_code
FB_free()
{
  if ( FastBuffer->UsedBuffers == 0 ) return FBError = FAST_NO_BUFFER ;
  FastBuffer->OldBuffer++ ;
#if FAST_VERSION>1
  if ( FastBuffer->OldBuffer >= FastBuffer->TotalBuffers )
#else
  if ( FastBuffer->OldBuffer >= MAX_FAST_BUFFER )
#endif
    FastBuffer->OldBuffer = 0 ;
  FastBuffer->UsedBuffers-- ;
  FastBuffer->FreeBuffers++ ;
  return FBError = SUCCESS ;
}
