#include <stdio.h>
#include <stdlib.h>

#include "fastlib.h"
#include "augererr.h"

get_buff()
{
  FAST_EVENT *buff ;

  if ( FB_get( &buff ) != SUCCESS )
    printf( "************* FB_get error %x ( %d )\n", FBError, FBError ) ;
  else printf( "FB_get buffer at %x\n", buff ) ;
}

use_buff()
{
  FAST_EVENT *buff ;

  if ( FB_use( &buff ) != SUCCESS )
    printf( "************* FB_use error %x ( %d )\n", FBError, FBError ) ;
  else printf( "FB_use buffer at %x\n", buff ) ;
}

free_buff()
{
  if ( FB_free() != SUCCESS )
    printf( "************* FB_free error %x ( %d )\n", FBError, FBError ) ;
}

main( int argc, char **argv )
{
  int nbuffers = 10 ;
  char str[16] ;
  error_code ok ;

  argv++ ;
  if ( *argv ) sscanf( *argv, "%d", &nbuffers ) ;
  /* open data module */
  ok = FB_init( nbuffers ) ;
  if ( ok != SUCCESS ) {
    printf( "************* Erreur %x ( %d )\n", ok, FBError ) ;
    exit( 0 ) ;
  }

  FB_status( stdout ) ;

  for( ; ; ) {
    printf( "Get, Use, Free, Quit :" ) ;
    fgets( str, 16, stdin ) ;
    if ( *str == 'g' ) get_buff() ;
    else if ( *str == 'u' ) use_buff() ;
    else if ( *str == 'f' ) free_buff() ;
    else if ( *str == 'q' ) break ;
    FB_status( stdout ) ;
  }
  FB_finish() ;

  exit( 0 ) ;
}
