#include <stdio.h>
#include <stdlib.h>

#include "feevts.h"
#include "gps_defs.h"
#include "gpslib.h"


void
GPS_read_fast( TimeStamp *debut, TimeStamp *fin )
{
  debut->second = *(GPS_FAST_SECOND) ;
  debut->nano = *(GPS_FAST_NANOS) ;
  fin->second = *(GPS_FAST_SECOND) ;
  fin->nano = *(GPS_FAST_NANOS) ;
}

void
GPS_read_slow( TimeStamp *debut )
{
  debut->second = *(GPS_SLOW_SECOND) ;
  debut->nano = *(GPS_SLOW_NANOS) ;
}

int
GPS_read_calib( unsigned int *cal )
{
  unsigned int value ;

  
  value = *(GPS_CALIB) ;
  *cal = value & GPS_CALIB_MASK ;
  return (value & GPS_IDENT_MASK)>>GPS_IDENT_SHIFT ;
}

int
GPS_read_calib40( unsigned int *cal )
{
  unsigned int value ;

  value = *(GPS_CALIB40) ;
  *cal = value & GPS_CALIB_MASK ;
  return (value & GPS_IDENT_MASK)>>GPS_IDENT_SHIFT ;
}

void
GPS_reset()
{
  *(GPS_RESET) = 0 ;
}
