#define POST_OFFICE_VERSION 4

#ifndef E_SUCCESS
#define E_SUCCESS 0
#define E_SIGNAL 1 /*esto lo puse yo*/
#endif

#define POST_SYNCH 0xBEBEFAD0
#define POST_ACTIVE 0xBEBED0D0
#define MINIMUM_MSG_SIZE 0x10

typedef struct post_msg post_msg_header ;
struct post_msg {
  post_msg_header *prev, *next ; /* pointeur sur previous/next block */
  int msg_ok ;
  int bsize ; /* taille du bloc */
  int size ; /* taille du message */
} ;

typedef struct {
  int synch,  /* Synchronisation word */
    active,   /* Creator is still active */
    version,  /* Numero de version */
    size,     /* Size available for messages */
    nbmess,   /* number of available messages */
    totalloc, /* number of allocated buffers */
    totdealloc, /* number of deallocated ... */
    totmsgin, /* Total number of messages sent */
    totmsgout;  /* Total number of messages received*/
  int gattempt, /* Nb of garbage collection */
    gsuccess ;  /* Nb of successful .... */
    post_notify notify ;
  process_id owner ;    /* PID of owner process */
#if POST_OFFICE_VERSION==99
  event_id exclusion ;
#else
  semaphore exclusion ; /* Mutual exclusion for access to the mailbox */
#endif
  post_msg_header
    *free_head, *free_tail,
    *msg_head, *msg_tail ;
  mh_com *addr ;/* Address of the data module */
  int
    reserved[8]; /* Reserved for future use */
  void *memory_arena ;
} mailbox ;
