typedef enum {
  POST_ERR_NO_MEMORY = 0x501, 
  POST_ERR_UNKNOWN, /* 502 */
  POST_ERR_ALREADY_EXIST, /* 503 */
  POST_ERR_EMPTY, /* 504 */
  POST_ERR_FULL, /* 505 */
  POST_ERR_NOTYOURS, /* 506 */
  POST_ERR_BAD_MODE, /* 507 */
  POST_ERR_BAD_MSG_POINTER, /* 508 */
  POST_ERR_TRUNCATED_MSG,
  POST_UNKNOWN_ERROR
} POST_OFFICE_ERR ;

typedef enum {
  POST_NTFY_NONE,
  POST_NTFY_SIGNAL, 
  POST_NTFY_EVENT,
  POST_NTFY_SETOR_EVENT,
  POST_NTFY_SETAND_EVENT,
  POST_NTFY_FLAG
} POST_NTFY_MODE ;

typedef struct {
  int mode, param1, param2 ;
} post_notify ;

typedef unsigned int MailboxId ;

int PostVersionId() ;

char *PostVersion() ;

char *PostError( error_code ok ) ;

error_code PostCreate( MailboxId *mbxid, char *name, int size, post_notify *mode ) ;

error_code PostLink( MailboxId *mbxid, char *name ) ;

error_code PostClose( MailboxId *mbxid ) ;

error_code PostSetNotify( MailboxId mbxid, post_notify *mode ) ;

error_code PostCleanUp( MailboxId mbxid ) ;

error_code PostAlloc( MailboxId mbxid, void **buffer, int size ) ;

error_code PostDealloc( MailboxId mbxid, void *buffer ) ;

error_code PostSend( MailboxId mbxid, void *buffer ) ;

error_code PostSendShrink( MailboxId mbxid, void *buffer, int size ) ;

error_code PostReceive( MailboxId mbxid, void **buffer, int *size ) ;

error_code PostCancel( MailboxId mbxid, void *buffer ) ;

error_code PostPut( MailboxId mbxid, void *data, int size ) ;

error_code PostGet( MailboxId mbxid, void *data, int *size ) ;
