#ifndef _RAW_DEFS_
#define _RAW_DEFS_

#include <stdlib.h>
#include <events.h>
#include <semaphore.h>

#include "listelib.h"
#include "rawlib.h"

typedef struct {
  int bsize ;    /* Size of buffers */
  int nbuffs, nfree, nused, count ;
  RAW_IDENT *free_head, *free_tail, *used_head, *used_tail ;
  RAW_IDENT *liste ;
  void *buffers ;
  semaphore raw_sema ;
  process_id waiting ; /* The producer is waiting till a buffer becomes free */
  signal_code wakeup ; /* The signal to send to the waiting producer */
  process_id spy_waiting ;  /* A spying process is waitong .... */
  signal_code spy_wakeup ; 
} RAW_BUFF_HEADER ;

static RAW_BUFF_HEADER *RAW_header = NULL ;
static mh_com *RAW_addr = NULL ;
static semaphore *RAW_sema = NULL ;

char *Str_use_status[] = {
  "Not-Ready", "Not-Used", "In-use", "Used", NULL
} ;
char *Str_spy_status[] = {
  "Not-Spyed", "In-Spy", "Spyed", NULL 
} ;

#endif
