#if ~defined(_RAW_LIB_)

#define _RAW_LIB_

typedef enum {
  RAW_NOT_READY,
  RAW_NOT_USED,
  RAW_IN_USE,
  RAW_USED
} RAW_USE_STATUS ;

typedef enum {
  RAW_NOT_SPYED,
  RAW_IN_SPY,
  RAW_SPYED
} RAW_SPY_STATUS ;

typedef enum {
  RAW_FRESHLY_CREATED,
  RAW_ALREADY_EXISTED,
  RAW_NOT_AVAILABLE
} RAW_BUFF_STATE ;

typedef struct RAW_ident RAW_IDENT ;

struct RAW_ident {
  RAW_IDENT *next, *prev ;
  int use_status, spy_status, num ;
  void *buffer ;
} ;


/* Global functions */
void RAW_buff_dump( FILE *, int part ) ;
error_code RAW_init( char *, int, int, int * ) ;
error_code RAW_reset() ;
error_code RAW_deinit() ;

/* Functions used by the producer */
error_code RAW_open( RAW_IDENT **, void ** ) ;
error_code RAW_open_w( RAW_IDENT **, void **, signal_code ) ;
error_code RAW_ready( RAW_IDENT * ) ;
error_code RAW_ready_by_num( int num ) ;

/* Functions used by the consumer */
error_code RAW_use( RAW_IDENT **pb, void **buff ) ;
error_code RAW_unuse( RAW_IDENT *pbid ) ;
error_code RAW_unuse_by_num( int num ) ;

/* Functions used by the spy */
error_code RAW_spy_old( RAW_IDENT **pb, void **buff ) ;
error_code RAW_spy_old_w( RAW_IDENT **pb, void **buff, signal_code wakeup ) ;
error_code RAW_unspy( RAW_IDENT *pbid ) ;
error_code RAW_unspy_by_num( int num ) ;

#endif
