/*********************************************************

  Librairie pour synchronisation des process lances par CONTROL.

  Control cree un event ( Ctrl_ready ) avec la valeur 0.
  Une fois lances les processes Readout, Trigger2 et Calib, Control se
  attend que cet event ait pris la valeur "CTRL_READY_MASK"

  Chaque tache lancee par Control doit, une fois prete, faire un ev_set
  pour mettre le bit qui lui correspond.

  Le fichier ready.h contient les definitions de ces bits pour chacune
  des taches.

  Chaque tache doit "se connaitre" en assignant a la variable
      Process_ident
  une des valeurs :
     READOUT_PROCESS
     TRIGGER2_PROCESS
     CALIB_PROCESS
     EVTSERVER_PROCESS

  Fonctions :
     ReadyInit()
          lancee en principe par Control.
	  cree l'event et/ou le remet a zero
     ReadyAll(signal_code *sig )
          utilisee par Control
	  attend que l'event prenne la bonne valeur.
     ReadyToGo()
          lancee par les enfants de Control
	  fait _ev_link a l'evenement, _os_evt_set et _ev_unlink

*****************************************/

#include <stdlib.h>
#include <errno.h>

#define MAIN_READY

#include "ready.h"

error_code
ReadyInit(  event_id *evid, char *event_name )
{
  /* Si peut Creer l'event, c'est tout.
     Sinon si peut linker dessus, le remettre a zero ( ev_set )
     Sinon grave erreur
     */
  int value = 0 ;
  error_code ok ;

  if ( (ok = _os_ev_creat( 0, 0, 0x333, evid, event_name,
			   0, 0 )) == SUCCESS ) return SUCCESS ;
  else if ( (ok = _os_ev_link( event_name, evid )) == SUCCESS )
    return SUCCESS ;
  else return ok ;
}

error_code
ReadyFinish( event_id evid, char *name )
{
  /* Unlink and delete the event */
  error_code ok ;

  if ( ok = _os_ev_unlink( evid ) ) return ok ;
  return _os_ev_delete( name ) ;
}

error_code
ReadyToGo( event_id evid, unsigned int mask )
{
  /* Link to the event.
     if event already known OR link succesful then
        set the proper mask
	return no-error
     else return error
     */
  error_code ok ;
  int value ;

  return _os_ev_setor( evid, &value, mask, 1 ) ;
}

error_code
ReadyAll( event_id evid, signal_code *sig, unsigned int mask )
{
  /* Wait till all processes ready */
  error_code ok ;
  int value ;

  *sig = 0 ;
  return _os_ev_allset( evid, &value, sig, mask ) ;
}

