/******************************************************************

  Gestion des Slowbuffers.

  Longueur fixe.
  Producteur : ItSlow
  Consomateur : Trigger2

  1 data module.
  MAX_SLOW_BUFFER buffers de longueur fixe.
  Gestion circulaire avec 2 indices : OldBuffer et NextBuffer.
  Deux compteurs : FreeBuffers et UsedBuffers.

  Producteur: 
  SB_get()
     Si ( FreeBuffers > 0 ) {
       FreeBuffers -- ;
       CurBuffer = NextBuffer ++ ;
       if ( NextBuffer >= MaxBuffers ) NextBuffer = 0 ;
       return addresse(CurBuffer) ;
     }
     sinon return NULL ;

  Consomateur:
  SB_use()
     Si ( UsedBuffers > 0 ) {
       return adresse( OldBuffer ) ;
     }
     sinon return NULL ;

  SB_free()
     OldBuffer++ ;
     Si ( OldBuffer >= MaxBuffer ) OldBuffer = 0 ;
     UsedBuffers-- ;
  }

  ATTENTION:
  Il n'y a pas de mecanisme d'exclusion !!!!! La fonction SB_get() est
  utilisee dans une routine d'IT, donc ininterruptible.
  Les fonctions SB_use et SB_free dans un process user, donc interruptible.

************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <const.h>

#define _SLOW_BUFFER_LIB_
#include "slowlib.h"
#include "augererr.h"

void
SB_status( FILE *fout )
{
  fprintf( fout, "Status of Slow Buffers\n" ) ;
#if SLOW_VERSION>1
  fprintf( fout, "  Total Buffers : %d\n", SlowBuffer->TotalBuffers ) ;
#endif
  fprintf( fout, "  Free Buffers  : %d\n", SlowBuffer->FreeBuffers ) ;
  fprintf( fout, "  Used Buffers  : %d\n", SlowBuffer->UsedBuffers ) ;
  fprintf( fout, "  Old Buffer    : %d\n", SlowBuffer->OldBuffer ) ;
  fprintf( fout, "  Next Buffer   : %d\n", SlowBuffer->NextBuffer ) ;
}

void
SB_finish()
{
  dm_finish( &SlowModule ) ;
}

error_code
SB_reset()
{
#if SLOW_VERSION>1
  SlowBuffer->FreeBuffers = SlowBuffer->TotalBuffers ;
#else
  SlowBuffer->FreeBuffers = MAX_SLOW_BUFFER ;
#endif
  SlowBuffer->UsedBuffers = 0 ;
  SlowBuffer->OldBuffer = 0 ;
  SlowBuffer->NextBuffer = 0 ;
  SlowBuffer->MaxUsed = 0 ;
  return SBError = SUCCESS ;
}

error_code
#if SLOW_VERSION>1
SB_init( int nbuffers )
#else
SB_init()
#endif
{
  /* Link sur data module */
#if SLOW_VERSION>1
  if ( dm_init( SLOW_MODULE,
		sizeof( SLOW_BUFFER ) + nbuffers*sizeof(SLOW_EVENT),
		(void **)&SlowBuffer,
		&SlowModule ) != 0 ) return SLOW_CANT_OPEN ;
  /* initialisation des pointeurs et indices */
  if ( SlowBuffer->TotalBuffers == 0 ) {
    SlowBuffer->TotalBuffers = nbuffers ;
    SB_reset() ;
  }
#else
  if ( dm_init( SLOW_MODULE, sizeof( SLOW_BUFFER ), (void **)&SlowBuffer,
		&SlowModule ) != 0 ) return SLOW_CANT_OPEN ;
  /* initialisation des pointeurs et indices */
  if ( SlowBuffer->FreeBuffers == 0 ) SB_reset() ;
#endif
  return SBError = SUCCESS ;
}

error_code
SB_get( SLOW_EVENT **buff )
{
  int curbuff ;

  if ( SlowBuffer->FreeBuffers == 0 ) return SBError = SLOW_NO_BUFFER ;

  curbuff = SlowBuffer->NextBuffer++ ;
#if SLOW_VERSION>1
  if ( SlowBuffer->NextBuffer >= SlowBuffer->TotalBuffers )
#else
  if ( SlowBuffer->NextBuffer >= MAX_SLOW_BUFFER )
#endif
    SlowBuffer->NextBuffer = 0 ;
  SlowBuffer->FreeBuffers-- ;
  SlowBuffer->UsedBuffers++ ;
  if ( SlowBuffer->MaxUsed < SlowBuffer->UsedBuffers )
    SlowBuffer->MaxUsed = SlowBuffer->UsedBuffers ;
  *buff = &SlowBuffer->buffers[curbuff] ;
  return SBError = SUCCESS ;
}

error_code
SB_use( SLOW_EVENT **buf )
{
  if ( SlowBuffer->UsedBuffers ) {
    *buf = &SlowBuffer->buffers[SlowBuffer->OldBuffer] ;
    return SBError = SUCCESS ;
  }
  else return SBError = SLOW_NO_BUFFER ;
}

error_code
SB_free()
{
  if ( SlowBuffer->UsedBuffers == 0 ) return SBError = SLOW_NO_BUFFER ;
  SlowBuffer->OldBuffer++ ;
#if SLOW_VERSION>1
  if ( SlowBuffer->OldBuffer >= SlowBuffer->TotalBuffers )
#else
  if ( SlowBuffer->OldBuffer >= MAX_SLOW_BUFFER )
#endif
    SlowBuffer->OldBuffer = 0 ;
  SlowBuffer->UsedBuffers-- ;
  SlowBuffer->FreeBuffers++ ;
  return SBError = SUCCESS ;
}
