#include <stdio.h>
#include <stdlib.h>

#include "slowlib.h"
#include "augererr.h"

get_buff()
{
  SLOW_EVENT *buff ;

  if ( SB_get( &buff ) != SUCCESS )
    printf( "SB_get error %x\n", SBError ) ;
  else printf( "SB_get buffer at %x\n", buff ) ;
}

use_buff()
{
  SLOW_EVENT *buff ;

  if ( SB_use( &buff ) != SUCCESS )
    printf( "SB_get error %x\n", SBError ) ;
  else printf( "SB_use buffer at %x\n", buff ) ;
}

free_buff()
{
  if ( SB_free() != SUCCESS )
    printf( "SB_free error %x\n", SBError ) ;
}

main()
{
  char str[16] ;
  error_code ok ;


  /* open data module */
  printf( "ttslow avec 2 buffers\n" ) ;
  ok = SB_init( 2 ) ;
  if ( ok != SUCCESS ) {
    printf( "Erreur %x\n", ok ) ;
    exit( 0 ) ;
  }

  SB_status( stdout ) ;

  for( ; ; ) {
    printf( "Get, Use, Free, Quit :" ) ;
    fgets( str, 16, stdin ) ;
    if ( *str == 'g' ) get_buff() ;
    else if ( *str == 'u' ) use_buff() ;
    else if ( *str == 'f' ) free_buff() ;
    else if ( *str == 'q' ) break ;
    SB_status( stdout ) ;
  }
  SB_finish() ;

  exit( 0 ) ;
}
