#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#include <types.h>

#include "slowlib_defs.h"
#include "slowcontrol.h"


/***************************************************************
  $Author: os9 $
  $Date: 2000/11/22 11:20:59 $
  $Revision: 1.7 $

  $Log: slowlib.c,v $
  Revision 1.7  2000/11/22 11:20:59  os9
  Modifs Malargue Nove 2000

  Revision 1.6  2000/10/16 12:51:08  os9
  Modif wait 10 millis (avec os_sleep)

  Revision 1.5  2000/10/02 10:00:03  os9
  Ajoute lecture des ADCs

  Revision 1.4  2000/09/26 15:44:33  os9
  Maintenant ca marche !

  Revision 1.3  2000/09/25 15:29:58  os9
  Ajoute fonctions OrWriteRegister, AndWriteRegister
  rt ReadBackRegister


***************************************************************/

/******************************************/
/*         general purpose functions      */
/******************************************/



/******************************************/
void wait_10micsec()
/******************************************/
{
  int i,j;
  
  for(i = 0;i <= 50;i++)   
    {
      j++;
      j--;   
    }
}

void wait_10millis()
{
  unsigned int tm = 0x80000002 ;
  signal_code dummy = 0 ;

  _os_sleep( &tm, &dummy ) ;

}

/******************************************/
/*                 ADC                    */
/******************************************/


static int ADCStates[ ADCState_max ] = { ADCState_adresses };
static int ADC_sleeping = 1;
static ADCErrors ADC_error = ADCError_none;

static int ADCMultiplexers[ADC_MUX] = 
{
  LAMX0,
  LAMX1,
  LAMX2,
  LAMX3
};

static int ADCVoies[ADC_MUXVOIES] = 
{
  SCAD0,
  SCAD1,
  SCAD2,
  SCAD3,
  SCAD4,
  SCAD5,
  SCAD6,
  SCAD7
};


/******************************************/
ADCErrors get_ADC_error()
/******************************************/
{
  return ADC_error;
}

/******************************************/
int is_ADC_done()
/******************************************/
/* read bit 15 du digital input register */
{
  return 1;
/*
  int ret;
  short* adr = (short*) (ADD_CARD + RDIR);
  
  ret = *adr;
  ret = ret & 0x8000;
  
  return ( ret != 0 );
*/
}

/******************************************/
unsigned int set_ADC_state( ADCState state )
/******************************************/
/* each time we read ADC, we have to tell */
/* what state ADC should be let in.       */
/* This depends on adress used to read    */
{
  unsigned int val;
  short* adr;
  
  if( state > ADCState_last ) {
      printf( "Bad stat: %x\n", state );
      ADC_error = ADCError_state;
      return 0;
    }
  
  adr = (short*)(ADD_CARD + ADCStates[state]);
  
  val = *adr;
  val = val & 0xfff;
  
  ADC_error = ADCError_none;
  
  return val;
}

/******************************************/
unsigned int nap_ADC()
/******************************************/
{
  ADC_sleeping = 0;
  return set_ADC_state( ADCState_nap );
}

/******************************************/
unsigned int sleep_ADC()
/******************************************/
{
  ADC_sleeping = 1;
  return set_ADC_state( ADCState_sleep );
}

/******************************************/
unsigned int awake_ADC()
/******************************************/
{
  ADC_sleeping = 0;
  return set_ADC_state( ADCState_awake );
}

/******************************************/
int is_ADC_sleeping()
/******************************************/
{
  return (ADC_sleeping == 1);
}

/******************************************/
unsigned int read_nap_ADC( unsigned int voie )
/******************************************/
{
  return read_ADC( voie, ADCState_nap );
}

/******************************************/
unsigned int read_awake_ADC( unsigned int voie )
/******************************************/
{
  return read_ADC( voie, ADCState_awake );
}

/******************************************/
unsigned int read_sleep_ADC( unsigned int voie )
/******************************************/
{
  return read_ADC( voie, ADCState_sleep );
}

/******************************************/
unsigned int read_ADC( unsigned int voie, ADCState state )
/******************************************/
{
  unsigned int k;
  unsigned int dummy = 0;
  unsigned int ret;
  short* adr;

  if( voie > ADC_LASTVOIE ) {
    printf( "Voie erronnee %d (%d)\n", voie, ADC_LASTVOIE );
    ADC_error = ADCError_voie;
    return 0;
  }


  /* open external multiplexer first */

  adr = (short*)(ADD_CARD + ADCMultiplexers[voie % ADC_MUX]);
  *adr = dummy;

  /* wait 10ms */
#if 0
  for( k = 0; k < 1000; k++ )
    {
      wait_10micsec();
    }
#else
  wait_10millis() ;
#endif
  /* open internal ADC multiplexer */

  adr = (short*)(ADD_CARD + ADCVoies[voie / ADC_MUX]);
  *adr = dummy;

  /* wait 10microsec */

  wait_10micsec();

  /* start conversion */

  *adr = dummy;

  /* wait 10microsec */

  wait_10micsec();
  wait_10micsec(); /* wait10micsec un poil trop court. A verifier */

  ret = set_ADC_state( state );
  /*	if( get_ADC_error() != ADCError_none ) */
  return ret;

  printf( "erreur; returning 0\n" );

  return 0;
}

/******************************************/
ADCErrors ReadADC( unsigned short *pchan, unsigned int InUse /* , int IsTPC */ )
/******************************************/
{
  unsigned int i = 0;
  unsigned short val = 0;
  ADCErrors ret = ADCError_none;

  for( i = 0; i < ADC_NBVOIE; i ++ ) {
    if( ( InUse >> i ) & 1 ) {
      pchan[i] = (unsigned short)read_ADC( i, ADCState_awake );
      if( ret == ADCError_none )
	ret = get_ADC_error();
    }
  }
  return ret;
}


/******************************************/
/*                 DAC                    */
/******************************************/


static int DACVoies[DACEnum_max][DAC_CHANNELS] = 
{
  {
    RDAC1_0,
    RDAC1_1,
    RDAC1_2,
    RDAC1_3
  },
  {
    RDAC2_0,
    RDAC2_1,
    RDAC2_2,
    RDAC2_3
  }
};
static DACErrors DAC_error = DACError_none;


/******************************************/
DACErrors get_DAC_error()
/******************************************/
{
  return DAC_error;
}

/******************************************/
unsigned int mV_readback_DAC( DACEnum dac, int channel )
/******************************************/
/*  returned value is a raw data          */
{
  unsigned int ret = raw_readback_DAC( dac, channel );

  ret = (unsigned int)(((float)ret*2500.)/4095.);
  return ret;
}

/******************************************/
unsigned int raw_readback_DAC( DACEnum dac, int channel )
/******************************************/
/*  returned value is a raw data          */
{
  unsigned short *adr;
  unsigned int ret;

  if( dac > DACEnum_last ) {
    DAC_error = DACError_enum;
    return 0;
  }

  if( channel > 3 ) {
    DAC_error = DACError_channel;
    return 0;
  }

  adr = (short*)(ADD_CARD + DACVoies[dac][channel]);

  ret = *adr;
  ret = ret & 0xfff;

  DAC_error = DACError_none;

  return ret;
}

/******************************************/
DACErrors mV_write_DAC( DACEnum dac, int channel, unsigned int mv )
/******************************************/
/*  last arg, mv, is in mV                */
{
  unsigned int val = (unsigned int)((4095.* (float)mv)/2500.);

  return raw_write_DAC( dac, channel, val );
}

/******************************************/
DACErrors raw_write_DAC( DACEnum dac, int channel, unsigned int val )
/******************************************/
/*  last arg, val, is a raw data          */
{
  short* adr;

  if( dac > DACEnum_last ) {
    DAC_error = DACError_enum;
    return DAC_error;
  }

  if( channel > 3 ) {
    DAC_error = DACError_channel;
    return DAC_error;
  }

  adr = (short*)(ADD_CARD + DACVoies[dac][channel]);

  *adr = val;

  DAC_error = DACError_none;

  return DAC_error;
}

/******************************************/
DACErrors ReadDAC( unsigned short *pchan, unsigned char InUse /* , int IsTPC */ )
/******************************************/
{
  int i = 0, j = 0 ;
  DACErrors ret = DACError_none;

  for( i = 0; i < DAC_CHANNELS; i ++ ) {
    if( ( InUse >> i ) & 1 ) {
      pchan[i] = (unsigned short)raw_readback_DAC( DACEnum_0, i );
      if( ret == DACError_none )
	ret = get_DAC_error();
    }
  }

  for( j = 0 ; j < DAC_CHANNELS ; i++, j++ ) {
    if( ( InUse >> i ) & 1 ) {
      pchan[i] = (unsigned short)raw_readback_DAC( DACEnum_1, j );
      if( ret == DACError_none )
	ret = get_DAC_error();
    }
  }

  return ret;
}

/******************************************/
DACErrors WriteDAC( unsigned short *pchan, unsigned char InUse /* , int IsTPC */ )
/******************************************/
{
  int i = 0, j = 0 ;
  unsigned short val = 0;
  DACErrors ret = DACError_none;
  DACErrors err = DACError_none;

  for( i = 0; i < DAC_CHANNELS; i ++ ) {
    if( ( InUse >> i ) & 1 ) {
      err = raw_write_DAC( DACEnum_0, i, pchan[i] );
      if( ret == DACError_none )
	ret = err;
    }
  }

  for( ; j < DAC_CHANNELS ; i++, j++ ) {
    if( ( InUse >> i ) & 1 ) {
      err = raw_write_DAC( DACEnum_1, j, pchan[i] );
      if( ret == DACError_none )
	ret = err;
    }
  }

  return ret;
}



/******************************************/
/*              Digital                   */
/******************************************/


/******************************************/
unsigned int read_digital_input()
/******************************************/
{
  unsigned int ret;
  short* adr = (short*)(ADD_CARD + RDIR);

  ret = *adr;

  return ret;
}

/******************************************/
unsigned int readback_digital_output()
/******************************************/
{
  unsigned int ret;
  short* adr = (short*)(ADD_CARD + RBDOR);

  ret = *adr;
  
  return ret;
}

/******************************************/
void write_digital_output( unsigned int val )
/******************************************/
{
  short* adr = (short*)(ADD_CARD + WDOR);

  *adr = val;
}

/******************************************/
unsigned short WriteRegister( unsigned short value )
/******************************************/
{
  *(short*)(ADD_CARD + WDOR) = value ;
  return value ;
}

unsigned short OrWriteRegister( unsigned short value )
{
  unsigned short old = *(short*)(ADD_CARD + RBDOR) ;

  *(short*)(ADD_CARD + WDOR) = value | old ;
  return old ;
}

unsigned short AndWriteRegister( unsigned short value )
{
  unsigned short old = *(short*)(ADD_CARD + RBDOR) ;

  *(short*)(ADD_CARD + WDOR) = value & old ;
  return old ;
}

unsigned short ReadBackRegister()
{
  return *(short*)(ADD_CARD + RBDOR) ;
}

/******************************************/
unsigned short ReadRegister ( )
/******************************************/
{
  return *(short*)(ADD_CARD + RDIR) ;
}
