#include <stdio.h>

#define FileName    "error.log"
#define MAXERRORS   50
#define MAXWARNINGS 10

FILE *CurLog= NULL;
int NbErrors=0, NbWarnings=0;

/* ===================== PrtLog =======================*
 * Print on error logfile                              *
 *    Arguments :                                      *
 *       str:   string to print                        *
 *       we:    =0 : warning                           *
 *              #0 : error                             *
 * ====================================================*/

int PrtLog( char *str, int we)
{
  if( we) {
    if( NbErrors++ > MAXERRORS) goto NoLog;
  }
  else 
    if( NbWarnings++ > MAXWARNINGS) goto NoLog;
  if( (CurLog= fopen( FileName, "a+")) == NULL) goto NoLog;
  if( we)
    fprintf( CurLog, "[E]%s", str);
  else
    fprintf( CurLog, "[W]%s", str);
  fclose( CurLog);
  return 0;
 NoLog:
  if(  we && NbErrors >   2*MAXERRORS)   return 1;
  if( !we && NbWarnings > 2*MAXWARNINGS) return 1;
  printf( "%s", str); fflush( stdout);
  return 1;
}
