#include <stdio.h>
#include <stdlib.h>

#define EVT_SIZE 2000

/**********************************************************************
 *       clusterize [-s<n>] <input> <output>
 *
 **********************************************************************/

unsigned char Buffer[EVT_SIZE] ;
int Minthresh = 1, Thresh = -1 ;
float Background = 0. ;

help()
{
  printf( "clusterize -s<seuil> input-file output-file\n" ) ;
  exit( 1 ) ;
}

void background()
{
  int i, n = 0 ;
  float rth = 0. ;
  unsigned char *p = Buffer ;
  for( i=0 ; i<EVT_SIZE ; i++, p++ ) if ( *p < 10 ) {
    rth += (float)*p ;
    n++ ;
  }
  Background =  rth/(float)n ;
}

int clusterize( short *in, short *out )
{
  int thresh ;
  int i, incluster = 0, begcluster = 0 ;
  int count = 0, bcount = 0 ;
  unsigned char *p, *p0 ;

  background() ;
  thresh = Thresh ;
  for( i=0, p = Buffer ; i<EVT_SIZE ; i++, p++ ) {
    if ( incluster ) {
      if ( *p < Minthresh ) {
	/* fin du cluster */
	/* if ( incluster > 1 ) { */
	  short sbytes, sbegin ;
	  /* printf( "Cluster begin at %d with %d bytes\n",
		  begcluster, incluster ) ; */
	  bcount += incluster ;
	  count++ ;
	  sbytes = incluster ;
	  sbegin = begcluster ;
	  fwrite( &sbegin, 1, 2, fout ) ;
	  fwrite( &sbytes, 1, 2, fout ) ;
	  fwrite( Buffer+begcluster, 1, incluster, fout ) ;
	  /* } */
	incluster = 0 ;
      }
      else incluster++ ;
    }
    else if ( *p >= thresh ) {
      /* y a un cluster. on va d'abord recuperer ce qu'il y a AVANT ( cad
	 meme les bytes < thresh ) */
      begcluster = i ;
      incluster++ ;
      for( p0 = p - 1 ; p0 > Buffer ; p0-- )
	if ( *p0 >= Minthresh ) {
	  incluster++ ;
	  begcluster-- ;
	}
	else break ;
    }
  }
  /* if ( incluster ) printf( "Cluster begin at %d with %d bytes\n",
			   begcluster, incluster ) ; */
#ifdef VERBOSE
  printf( "****** Nb de clusters : %d\n       Nb de data : %d\n",
	  count, bcount ) ;
  printf( "       Nb total de bytes : %d\n", bcount + count*4 ) ;
#endif
  return bcount + count*3 ;
}

main( int argc, char **argv )
{
  FILE *fin, *fout ;
  int i, j, nfile = 0, nbytes ;
  float size = 0. ;
  unsigned char *p ;
  char **av ;
  char fname[256] ;
  argv++ ;
  if ( !*argv ) help() ;

  if ( **argv == '-' ) {
    char *p = *argv ;
    p++ ;
    switch ( *p ) {
    case 's': p++ ; if ( *p == '=' ) p++ ;
      sscanf( p, "%d", &Thresh ) ; break ;
    default: help() ;
    }
  }
  else help() ;

  argv++ ;
  if ( !*argv ) help() ;
  if ( !(fin = fopen( *argv, "r" )) ) {
    printf( "Can't open \"%s\"\n", *argv ) ;
    help() ;
  }
  argv++ ;
  fread( Buffer, 1, EVT_SIZE, fin ) ;

  if ( !*argv ) help() ;
  fout = fopen( *argv, "w" ) ;
  nbytes = clusterize( fout ) ;
  printf( "      Background : %6.2f\n", Background ) ;
  fclose( fin ) ;
  size += (float)nbytes ;
}


